### Spring Boot文档

本节提供一个Spring Boot参考文档的简明概述。你可以把它作为文档其余部分的导航。你可以从头到尾依次阅读该参考指南，或跳过你不感兴趣的章节。

* 关于本文档

Spring Boot参考指南有[html](http://docs.spring.io/spring-boot/docs/1.3.0.BUILD-SNAPSHOT/reference/html)，[pdf](http://docs.spring.io/spring-boot/docs/1.3.0.BUILD-SNAPSHOT/reference/pdf/spring-boot-reference.pdf)和[epub](http://docs.spring.io/spring-boot/docs/1.3.0.BUILD-SNAPSHOT/reference/epub/spring-boot-reference.epub)形式的文档。在[docs.spring.io/spring-boot/docs/current/reference](http://docs.spring.io/spring-boot/docs/current/reference)可获取到最新的副本。

本文档的副本可自己使用，也可以分发给其他人，假如你对这些副本不收取任何费用，并且不管以打印还是电子版每个副本都包含版权声明。

* 获取帮助

使用Spring Boot遇到麻烦，我们很乐意帮忙！

- 尝试[How-to’s](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#howto)－它们为多数常见问题提供解决方案。
- 学习Spring基础知识－Spring Boot是在很多Spring项目上构建的，查看[spring.io](http://spring.io/)站点可以获取大量参考文档。如果你刚开始使用Spring，可以尝试其中的一个[指导](http://spring.io/guides)。
- 提问题－我们时刻监控着[stackoverflow.com](http://stackoverflow.com/)上标记[spring-boot](http://stackoverflow.com/tags/spring-boot)的问题。
- 在[github.com/spring-projects/spring-boot/issues](https://github.com/spring-projects/spring-boot/issues)报告Spring Boot的bug。

**注**：Spring Boot的全部都是开源的，包括文档！如果你发现问题有问题，或只是想提高它们，请[参与进来](http://github.com/spring-projects/spring-boot/tree/master)！

* 第一步

如果你想从总体上对Spring Boot或Spring入门，可以从[这里开始](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#getting-started)！

- 从零开始：[概述](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#getting-started-introducing-spring-boot)｜[要求](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#getting-started-system-requirements)｜[安装](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#getting-started-installing-spring-boot)
- 教程：[第一部分](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#getting-started-first-application)｜[第二部分](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#getting-started-first-application-code)
- 运行示例：[第一部分](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#getting-started-first-application-run)｜[第二部分](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#getting-started-first-application-executable-jar)

* 使用Spring Boot

准备开始实际使用Spring Boot？[我们已经为你做好掩护](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot).

- 构建系统：[Maven](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-maven)｜[Gradle](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-gradle)｜[Ant](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-ant)｜[Starter POMs](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-starter-poms)
- 最佳实践：[代码结构](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-structuring-your-code)｜[@Configuration](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-configuration-classes)｜[@EnableAutoConfiguration](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-auto-configuration)｜[Beans和依赖注入](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-spring-beans-and-dependency-injection)
- 运行代码：[IDE](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-running-from-an-ide)｜[Packaged](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-running-as-a-packaged-application)｜[Maven](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-running-with-the-maven-plugin)｜[Gradle](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-running-with-the-gradle-plugin)
- 应用打包：[生产jars](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#using-boot-packaging-for-production)
- Spring Boot命令行：[使用CLI](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#cli)

* 了解Spring Boot特性

需要更多Spring Boot核心特性？[这是为你准备的](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features)！

- 核心特性：[SpringApplication](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-spring-application)｜[外部配置](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-external-config)｜[Profiles](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-profiles)｜[日志](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-logging)
- Web应用：[MVC](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-spring-mvc)｜[内嵌容器](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-embedded-container)
- 使用数据：[SQL](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-sql)｜[NO-SQL](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-nosql)
- 消息：[概述](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-messaging)｜[JMS](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-jms)
- 测试：[概述](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-testing)｜[Boot应用](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-testing-spring-boot-applications)｜[工具](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-test-utilities)
- 扩展：[Auto-configuration](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-developing-auto-configuration)｜[@Conditions](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#boot-features-condition-annotations)

* 迁移到生存环境

当你准备将你的Spring Boot应用推送到生产环境时，我们为你准备了一些你[可能喜欢的技巧](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#production-ready)！

- 管理端点：[概述](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#production-ready-endpoints)｜[自定义](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#production-ready-customizing-endpoints)
- 连接可选项：[HTTP](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#production-ready-monitoring)｜[JMX](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#production-ready-jmx)｜[SSH](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#production-ready-remote-shell)
- 监控：[指标](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#production-ready-metrics)｜[审计](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#production-ready-auditing)｜[追踪](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#production-ready-tracing)｜[进程](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#production-ready-process-monitoring)

* 高级主题

最后，我们为高级用户准备了一些主题。

- 云部署：[Cloud Foundry](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#cloud-deployment-cloud-foundry)｜[Heroku](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#cloud-deployment-heroku)｜[CloudBees](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#)
- 构建工具插件：[Maven](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#build-tool-plugins-maven-plugin)｜[Gradle](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#build-tool-plugins-gradle-plugin)
- 附录：[应用属性](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#common-application-properties)｜[Auto-configuration类](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#auto-configuration-classes)｜[可执行Jars](http://docs.spring.io/spring-boot/docs/current-SNAPSHOT/reference/htmlsingle/#executable-jar)
